// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth:

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"


#include "clock.inc"
#include "eyes.inc"

#declare saeule =
union {
	box { < 0.4, 0.7, 0.4 >, < -0.4, 0.5, -0.4 > }
	box { < 0.4, 2.7, 0.4 >, < -0.4, 2.5, -0.4 > }
	box { < 0.2, 2.5, 0.2 >, < -0.2, 0.7, -0.2 > }
	sphere { < 0, 2.9, 0 >, 0.2 }
	texture { T_Stone26 finish { specular 1 roughness 0.1 } }
}

camera
{
  location  < 5.0 , 3, -12 >
  look_at   <0.0 ,  1.0 , 0>
}

/*light_source {
	< -500, 1000, -200 >
	color White
}*/

//*********************************************************************

light_source
{
  0*x 							// light's position (translated below)
  color rgb 1.0  				// light's color
								// <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> 			// lights spread out across this distance (x * z)
  10, 10                			// total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          			// 0,1,2,3...
  jitter              			// adds random softening of light
  translate < -20, 80, -40>   		// <x y z> position of light
}

//*********************************************************************
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.0 // distance from the origin in the direction of the surface normal
	texture { Water scale 4 }
}

plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.2 // distance from the origin in the direction of the surface normal
	texture { pigment { color rgb < 0, 0, 0.75 > } }
}






// Create an infinite sphere around scene and allow any texture on it
sky_sphere { S_Cloud3 }


// *********** Plattform **************

union {
	box { < 4, 0.5, 4 >, < -4, -0.5, -4 > }
	cylinder { <  4, 0,  4 >, <  4, 0, -4 >, 0.5 }
	cylinder { <  4, 0, -4 >, < -4, 0, -4 >, 0.5 }
	cylinder { < -4, 0, -4 >, < -4, 0,  4 >, 0.5 }
	cylinder { < -4, 0,  4 >, <  4, 0,  4 >, 0.5 }
	sphere { <  4, 0,  4 >, 0.5 }
	sphere { <  4, 0, -4 >, 0.5 }
	sphere { < -4, 0, -4 >, 0.5 }
	sphere { < -4, 0,  4 >, 0.5 }
	texture {
		crackle
		texture_map {
			[ 0   T_Stone1  normal { wrinkles 1 scale 0.01 } ]
			[ 0.1 T_Stone1  normal { wrinkles 1 scale 0.01 } ]
			[ 0.1 T_Stone12 ]
			[ 1   T_Stone12 ]
		}
		scale 0.5
	}
	translate y*-1
}

union {
	object { saeule translate <  3.6, 0,  3.6 > }
	object { saeule translate < -3.6, 0,  3.6 > }
	object { saeule translate <  3.6, 0, -3.6 > }
	object { saeule translate < -3.6, 0, -3.6 > }
	translate y*-1
}

#declare Glied =
union {
	difference {
		torus { 1, 0.4 }
		box { < 1.5, 0.6, 1.5 >, < 0, -0.6, -1.5 > }
		translate < -2, 0, 0 >
	}
	cylinder { < -2, 0,  1 >, < 2, 0,  1 >, 0.4 }
	cylinder { < -2, 0, -1 >, < 2, 0, -1 >, 0.4 }
	difference {
		torus { 1, 0.4 }
		box { < 0, 0.6, 1.5 >, < -1.5, -0.6, -1.5 > }
		translate < 2, 0, 0 >
	}
	texture {
		T_Copper_3C
	}
}

#declare Glied_1 = object { Glied }
#declare Glied_2 = object { Glied rotate x*90 }

#declare Kette =
union {
	object { Glied_1 }
	object { Glied_2 translate x*5.2 }
	object { Glied_1 translate x*10.4 }
	object { Glied_2 translate x*15.6 }
	object { Glied_1 translate x*20.8 }
	object { Glied_2 translate x*26.0 }
	object { Glied_1 translate x*31.2 }
	object { Glied_2 translate x*-5.2 }
	object { Glied_1 translate x*-10.4 }
	object { Glied_2 translate x*-15.6 }
	object { Glied_1 translate x*-20.8 }
	object { Glied_2 translate x*-26.0 }
	object { Glied_1 translate x*-31.2 }
	scale 0.1
}

object { Kette
	rotate x*45
	translate < 0, 1, -3.6 >
}

object { Kette
	rotate x*45
	translate < 0, 1, 3.6 >
}

object { Kette
	rotate x*45
	rotate y*90
	translate < 3.6, 1, 0 >
}

object { Kette
	rotate x*45
	rotate y*90
	translate < -3.6, 1, 0 >
}

object { Uhr  scale 0.5 translate < 0, 0, 0 > }


//***************** The Heigh-Field **********************

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field
{
  tga "hfield.tga"
  smooth
  texture
  {
    pigment
    {
      image_map { tga "hfield.tga" map_type 0 interpolate 2 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
  }
	translate < -0.5, 0, -0.5 >
	scale < 100, 5, 100 >
	translate < 0, -1.6, 0 >
}

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field
{
  tga "hfield2.tga"
  smooth
  texture
  {
    pigment
    {
		gradient y
		color_map {
			[ 0   color rgb < 0.2, 0, 0 > ]
			[ 0.2 color rgb < 0, 0.8, 0 > ]
			[ 0.5 color rgb < 1, 1, 1 > ]
			[ 1   color rgb < 1, 1, 1 > ]
		}
    }
  }
	translate < -0.5, 0, -0.5 >
	scale < 200, 50, 200 >
	translate < 0, -1.6, 300 >
}


// *************** The creatures *****************

object { eyes
	rotate y*180
	translate < 0, -1,  -6 >
}

object { eyes
	rotate y*-45
	translate < -7, -0.5, 0 >
}

object { eyes
	translate < 0, -0.5, 10 >
}


object { eyes
	translate < -4, -0.5, 12 >
}

object { eyes
	translate < 6, -0.5, 14 >
}

object { eyes
	rotate y*-45
	translate < -10, -0.5, 5 >
}
